<?php
/**
 * Shopgate GmbH
 *
 * URHEBERRECHTSHINWEIS
 *
 * Dieses Plugin ist urheberrechtlich geschützt. Es darf ausschließlich von Kunden der Shopgate GmbH
 * zum Zwecke der eigenen Kommunikation zwischen dem IT-System des Kunden mit dem IT-System der
 * Shopgate GmbH über www.shopgate.com verwendet werden. Eine darüber hinausgehende Vervielfältigung, Verbreitung,
 * öffentliche Zugänglichmachung, Bearbeitung oder Weitergabe an Dritte ist nur mit unserer vorherigen
 * schriftlichen Zustimmung zulässig. Die Regelungen der §§ 69 d Abs. 2, 3 und 69 e UrhG bleiben hiervon unberührt.
 *
 * COPYRIGHT NOTICE
 *
 * This plugin is the subject of copyright protection. It is only for the use of Shopgate GmbH customers,
 * for the purpose of facilitating communication between the IT system of the customer and the IT system
 * of Shopgate GmbH via www.shopgate.com. Any reproduction, dissemination, public propagation, processing or
 * transfer to third parties is only permitted where we previously consented thereto in writing. The provisions
 * of paragraph 69 d, sub-paragraphs 2, 3 and paragraph 69, sub-paragraph e of the German Copyright Act shall remain unaffected.
 *
 * @author Shopgate GmbH <interfaces@shopgate.com>
 */

(defined('_VALID_XTC') || defined('_GM_VALID_CALL')) or die('Direct Access to this location is not allowed.');

if (strpos(MODULE_PAYMENT_INSTALLED, 'shopgate.php') !== false) {
    
    // determine configuration language: $_GET > $_SESSION > global
    $sg_language_get = (!empty($_GET['sg_language'])
        ? '&sg_language=' . $_GET['sg_language']
        : ''
    );
    
    $displayCssClass = 'fav_drag_item';
    $surroundingHtml = array(
        'start' => '<div class="leftmenu_head" style="background-image:url(images/gm_icons/module.png)">' . BOX_SHOPGATE
            . '</div>' .
            '<div class="leftmenu_collapse leftmenu_collapse_opened"> </div>' .
            '<ul class="leftmenu_box" id="BOX_HEADING_SHOPGATE">',
        'end'   => '</ul>',
    );
    $surroundingTags = array(
        'start' => '<li class="leftmenu_body_item">',
        'end'   => '</li>',
    );
    $hrefIdList      = array(
        'basic'    => 'id="BOX_SHOPGATE_BASIC" ',
        'merchant' => 'id="BOX_SHOPGATE_MERCHANT" ',
    );
    $linkNamePrefix  = '';
    echo($surroundingHtml['start']);
    
    if (($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['shopgate'] == '1')) {
        echo $surroundingTags['start'] . '<a ' . $hrefIdList['basic'] . 'href="' . xtc_href_link(
                FILENAME_SHOPGATE . "?sg_option=info{$sg_language_get}", '', 'NONSSL'
            )
            . '" class="' . $displayCssClass . '">' . $linkNamePrefix . BOX_SHOPGATE_INFO . '</a>'
            . $surroundingTags['end'];
        echo $surroundingTags['start'] . '<a ' . $hrefIdList['basic']
            . ' target="_blank" href="https://support.shopgate.com/hc/en-us/articles/202798386" class="'
            . $displayCssClass . '">' . $linkNamePrefix . BOX_SHOPGATE_HELP . '</a>' . $surroundingTags['end'];
        echo $surroundingTags['start'] . '<a ' . $hrefIdList['basic'] . 'href="' . xtc_href_link(
                FILENAME_SHOPGATE . "?sg_option=config{$sg_language_get}", '', 'NONSSL'
            )
            . '" class="' . $displayCssClass . '">' . $linkNamePrefix . BOX_SHOPGATE_CONFIG . '</a>'
            . $surroundingTags['end'];
    }
    
    echo($surroundingHtml['end']);
    
}
