<?php

/**
 * Shopgate GmbH
 *
 * URHEBERRECHTSHINWEIS
 *
 * Dieses Plugin ist urheberrechtlich geschützt. Es darf ausschließlich von Kunden der Shopgate GmbH
 * zum Zwecke der eigenen Kommunikation zwischen dem IT-System des Kunden mit dem IT-System der
 * Shopgate GmbH über www.shopgate.com verwendet werden. Eine darüber hinausgehende Vervielfältigung, Verbreitung,
 * öffentliche Zugänglichmachung, Bearbeitung oder Weitergabe an Dritte ist nur mit unserer vorherigen
 * schriftlichen Zustimmung zulässig. Die Regelungen der §§ 69 d Abs. 2, 3 und 69 e UrhG bleiben hiervon unberührt.
 *
 * COPYRIGHT NOTICE
 *
 * This plugin is the subject of copyright protection. It is only for the use of Shopgate GmbH customers,
 * for the purpose of facilitating communication between the IT system of the customer and the IT system
 * of Shopgate GmbH via www.shopgate.com. Any reproduction, dissemination, public propagation, processing or
 * transfer to third parties is only permitted where we previously consented thereto in writing. The provisions
 * of paragraph 69 d, sub-paragraphs 2, 3 and paragraph 69, sub-paragraph e of the German Copyright Act shall remain
 * unaffected.
 *
 * @author Shopgate GmbH <interfaces@shopgate.com>
 */
class ShopgateCustomizerSetHelper
{
    /**
     * @param array $gxCustomizerSurfaceElement
     * @param int   $inputFieldNumber
     * @param int   $inputCount
     *
     * @return array
     */
    public function generateInputField($gxCustomizerSurfaceElement, $inputFieldNumber, $inputCount)
    {
        $label      = '';
        $labelField = $inputCount > 1
            ? 'elements_values_name'
            : 'surfaces_name';

        // always precede the surfaces description name if not empty
        if (!empty($gxCustomizerSurfaceElement[$labelField])) {
            $textSpacing = '';
            if (!empty($label)) {
                $textSpacing = ' ';
            }
            // use uppercase for the surface name, since it is used as uppercase in the shop-frontend
            $label =
                strtoupper($gxCustomizerSurfaceElement[$labelField]) . $textSpacing . $label;
        }

        // take at least some name if none could be found, yet
        if (empty($label)) {
            $label = $gxCustomizerSurfaceElement['surfaces_groups_name'];
        }

        $infotext = !empty($gxCustomizerSurfaceElement['elements_values_value'])
            ? $gxCustomizerSurfaceElement['elements_values_value']
            : '';
        // remove line-feeds from the label and infotext elements
        $labelParts = explode("\n", str_replace("\r", '', $label));
        $label      = '';
        foreach ($labelParts as $labelPart) {
            $labelPart = trim($labelPart);
            if (strlen($labelPart) > 0) {
                $label .= " {$labelPart}";
            }
        }
        $infotextParts = explode("\n", str_replace("\r", '', $infotext));
        $infotext      = '';
        foreach ($infotextParts as $infotextPart) {
            $infotextPart = trim($infotextPart);
            if (strlen($infotextPart) > 0) {
                $infotext .= " {$infotextPart}";
            }
        }

        return array(
            "input_field_{$inputFieldNumber}_type"       => 'text',
            "input_field_{$inputFieldNumber}_number"     => 'gxcust_el_val_id_#' .
                $gxCustomizerSurfaceElement['surfaces_groups_id'] . '.' .
                $gxCustomizerSurfaceElement['surfaces_id'] . '.' .
                $gxCustomizerSurfaceElement['elements_values_id'],
            "input_field_{$inputFieldNumber}_label"      => $label,
            "input_field_{$inputFieldNumber}_infotext"   => $infotext,
            "input_field_{$inputFieldNumber}_required"   => 0,
            "input_field_{$inputFieldNumber}_add_amount" => 0
        );
    }
}