<?php

/**
 * Shopgate GmbH
 *
 * URHEBERRECHTSHINWEIS
 *
 * Dieses Plugin ist urheberrechtlich geschützt. Es darf ausschließlich von Kunden der Shopgate GmbH
 * zum Zwecke der eigenen Kommunikation zwischen dem IT-System des Kunden mit dem IT-System der
 * Shopgate GmbH über www.shopgate.com verwendet werden. Eine darüber hinausgehende Vervielfältigung, Verbreitung,
 * öffentliche Zugänglichmachung, Bearbeitung oder Weitergabe an Dritte ist nur mit unserer vorherigen
 * schriftlichen Zustimmung zulässig. Die Regelungen der §§ 69 d Abs. 2, 3 und 69 e UrhG bleiben hiervon unberührt.
 *
 * COPYRIGHT NOTICE
 *
 * This plugin is the subject of copyright protection. It is only for the use of Shopgate GmbH customers,
 * for the purpose of facilitating communication between the IT system of the customer and the IT system
 * of Shopgate GmbH via www.shopgate.com. Any reproduction, dissemination, public propagation, processing or
 * transfer to third parties is only permitted where we previously consented thereto in writing. The provisions
 * of paragraph 69 d, sub-paragraphs 2, 3 and paragraph 69, sub-paragraph e of the German Copyright Act shall remain unaffected.
 *
 * @author Shopgate GmbH <interfaces@shopgate.com>
 */
class ShopgateDatabaseHelper
{
    /**
     * use via checkTable()
     *
     * @var array
     */
    private $tableExistsCache = array();
    
    /**
     * check if a list of database tables exist
     *
     * @param array $tableNames
     *
     * @return bool
     */
    public function checkTables(array $tableNames)
    {
        foreach ($tableNames as $tableName) {
            if (!$this->checkTable($tableName)) {
                return false;
            }
        }
        
        return true;
    }
    
    /**
     * Check if a database table exists
     *
     * @param string $tableName
     *
     * @return bool
     */
    public function checkTable($tableName)
    {
        if (!isset($this->tableExistsCache[$tableName])) {
            $result                             = xtc_db_query("show tables like '{$tableName}'");
            $this->tableExistsCache[$tableName] = !(empty($result) || (xtc_db_num_rows($result) <= 0));
        }
        
        return $this->tableExistsCache[$tableName];
    }
    
    /**
     * check if a column in a database table exist
     * 
     * @param $table
     * @param $column
     *
     * @return bool
     */
    public function checkColumn($table, $column)
    {
        if (!$this->checkTable($table)) {
            return false;
        }
        $result = xtc_db_query("SHOW COLUMNS FROM `" . $table . "` LIKE '" . $column . "'");
        while ($columnResult = xtc_db_fetch_array($result)) {
            if (isset($columnResult['Field']) && $columnResult['Field'] == $column) {
                return true;
            }
        }
        
        return false;
    }
    
    /**
     * Checks if the given table exists
     *
     * @param string $tableName
     *
     * @throws ShopgateLibraryException
     * 
     * @return boolean
     */
    public function tableExists($tableName)
    {
        $tableName = trim($tableName);
        if (empty($tableName)) {
            return false;
        }
        
        // Get all table names
        $query = xtc_db_query("SHOW TABLES");
        if (!$query) {
            // DB-Error
            throw new ShopgateLibraryException(
                ShopgateLibraryException::PLUGIN_DATABASE_ERROR,
                "Shopgate Plugin - Error checking for table \"$tableName\".", true
            );
        }
        while ($array = xtc_db_fetch_array($query)) {
            $array = array_values($array);
            
            // Check for table name
            if ($array[0] == $tableName) {
                return true;
            }
        }
        
        // The requested table has not been found if execution reaches here
        return false;
    }
}
