<?php

/**
 * Shopgate GmbH
 *
 * URHEBERRECHTSHINWEIS
 *
 * Dieses Plugin ist urheberrechtlich geschützt. Es darf ausschließlich von Kunden der Shopgate GmbH
 * zum Zwecke der eigenen Kommunikation zwischen dem IT-System des Kunden mit dem IT-System der
 * Shopgate GmbH über www.shopgate.com verwendet werden. Eine darüber hinausgehende Vervielfältigung, Verbreitung,
 * öffentliche Zugänglichmachung, Bearbeitung oder Weitergabe an Dritte ist nur mit unserer vorherigen
 * schriftlichen Zustimmung zulässig. Die Regelungen der §§ 69 d Abs. 2, 3 und 69 e UrhG bleiben hiervon unberührt.
 *
 * COPYRIGHT NOTICE
 *
 * This plugin is the subject of copyright protection. It is only for the use of Shopgate GmbH customers,
 * for the purpose of facilitating communication between the IT system of the customer and the IT system
 * of Shopgate GmbH via www.shopgate.com. Any reproduction, dissemination, public propagation, processing or
 * transfer to third parties is only permitted where we previously consented thereto in writing. The provisions
 * of paragraph 69 d, sub-paragraphs 2, 3 and paragraph 69, sub-paragraph e of the German Copyright Act shall remain unaffected.
 *
 * @author Shopgate GmbH <interfaces@shopgate.com>
 */
class ShopgateItemAttributeModel extends ShopgateObject
{
    /**
     * read products attrubute data from database
     *
     * @param int    $productsId
     * @param bool   $normalizeKey
     * @param string $normalizationDelimiter
     *
     * @return array
     *
     * @throws ShopgateLibraryException
     */
    public function getAttributesFromDatabase($productsId, $normalizeKey = false, $normalizationDelimiter = '-')
    {
        $attributes = array();

        $query = sprintf(
            "
            SELECT
                *
            FROM %s AS a
                WHERE a.products_id = %s",
            TABLE_PRODUCTS_ATTRIBUTES,
            $productsId
        );

        $result = xtc_db_query($query);

        if (!$result) {
            throw new ShopgateLibraryException(
                ShopgateLibraryException::PLUGIN_DATABASE_ERROR,
                "Shopgate Plugin - Error checking for table \"" . TABLE_PRODUCTS_ATTRIBUTES . "\".",
                true
            );
        }

        // structure the data in a way so it can be accessed in an easy fashion
        while ($row = xtc_db_fetch_array($result)) {
            $key = $row['products_attributes_id'];
            if ($normalizeKey) {
                $key = implode($normalizationDelimiter, array($row['options_id'], $row['options_values_id']));
            }
            $attributes[$key] = $row;
        }

        return $attributes;
    }

    /**
     * @param int $productsId
     *
     * @return array
     *
     * @throws ShopgateLibraryException
     */
    public function getPropertyCombinationsFromDatabase($productsId)
    {
        $attributes = array();

        $query = sprintf(
            "
            SELECT
                *
            FROM %s AS a
                WHERE a.products_id = %s",
            TABLE_PRODUCTS_PROPERTIES_COMBIS,
            $productsId
        );

        $result = xtc_db_query($query);

        if (!$result) {
            throw new ShopgateLibraryException(
                ShopgateLibraryException::PLUGIN_DATABASE_ERROR,
                "Shopgate Plugin - Error checking for table \"" . TABLE_PRODUCTS_PROPERTIES_COMBIS . "\".",
                true
            );
        }

        // structure the data in a way so it can be accessed in an easy fashion
        while ($row = xtc_db_fetch_array($result)) {
            $attributes[$row['products_properties_combis_id']] = $row;
        }

        return $attributes;
    }
}
