<?php

/**
 * Shopgate GmbH
 *
 * URHEBERRECHTSHINWEIS
 *
 * Dieses Plugin ist urheberrechtlich geschützt. Es darf ausschließlich von Kunden der Shopgate GmbH
 * zum Zwecke der eigenen Kommunikation zwischen dem IT-System des Kunden mit dem IT-System der
 * Shopgate GmbH über www.shopgate.com verwendet werden. Eine darüber hinausgehende Vervielfältigung, Verbreitung,
 * öffentliche Zugänglichmachung, Bearbeitung oder Weitergabe an Dritte ist nur mit unserer vorherigen
 * schriftlichen Zustimmung zulässig. Die Regelungen der §§ 69 d Abs. 2, 3 und 69 e UrhG bleiben hiervon unberührt.
 *
 * COPYRIGHT NOTICE
 *
 * This plugin is the subject of copyright protection. It is only for the use of Shopgate GmbH customers,
 * for the purpose of facilitating communication between the IT system of the customer and the IT system
 * of Shopgate GmbH via www.shopgate.com. Any reproduction, dissemination, public propagation, processing or
 * transfer to third parties is only permitted where we previously consented thereto in writing. The provisions
 * of paragraph 69 d, sub-paragraphs 2, 3 and paragraph 69, sub-paragraph e of the German Copyright Act shall remain unaffected.
 *
 * @author Shopgate GmbH <interfaces@shopgate.com>
 */
class ShopgateShippingModel
{
    
    /**
     * read all shipping module data from database
     *
     * @return mixed
     */
    public function getShippingCountriesFromConstants()
    {
        $shippingQuery
            = "SELECT c.configuration_value AS 'countries' 
               FROM " . TABLE_CONFIGURATION . " AS c 
               WHERE c.configuration_key LIKE 'MODULE_SHIPPING_%_COUNTRIES_%' AND c.configuration_value != ''";
        
        return xtc_db_query($shippingQuery);
    }
    
    /**
     * read the shipping configuration data from database regarding shipping class name
     *
     * @param $className
     *
     * @return array
     */
    public function getShippingConfigurationValuesByClassName($className)
    {
        $query          = "SELECT c.configuration_key, c.configuration_value FROM "
            . TABLE_CONFIGURATION . " AS c WHERE configuration_key like \"MODULE_SHIPPING_"
            . strtoupper($className) . "%\" ;";
        $result         = xtc_db_query($query);
        $shippingConfig = array();
        
        while ($config = xtc_db_fetch_array($result)) {
            $shippingConfig[$config["configuration_key"]] = $config["configuration_value"];
        }
        
        return $shippingConfig;
    }
} 
