<?php

/**
 * Shopgate GmbH
 *
 * URHEBERRECHTSHINWEIS
 *
 * Dieses Plugin ist urheberrechtlich geschützt. Es darf ausschließlich von Kunden der Shopgate GmbH
 * zum Zwecke der eigenen Kommunikation zwischen dem IT-System des Kunden mit dem IT-System der
 * Shopgate GmbH über www.shopgate.com verwendet werden. Eine darüber hinausgehende Vervielfältigung, Verbreitung,
 * öffentliche Zugänglichmachung, Bearbeitung oder Weitergabe an Dritte ist nur mit unserer vorherigen
 * schriftlichen Zustimmung zulässig. Die Regelungen der §§ 69 d Abs. 2, 3 und 69 e UrhG bleiben hiervon unberührt.
 *
 * COPYRIGHT NOTICE
 *
 * This plugin is the subject of copyright protection. It is only for the use of Shopgate GmbH customers,
 * for the purpose of facilitating communication between the IT system of the customer and the IT system
 * of Shopgate GmbH via www.shopgate.com. Any reproduction, dissemination, public propagation, processing or
 * transfer to third parties is only permitted where we previously consented thereto in writing. The provisions
 * of paragraph 69 d, sub-paragraphs 2, 3 and paragraph 69, sub-paragraph e of the German Copyright Act shall remain
 * unaffected.
 *
 * @author             Shopgate GmbH <interfaces@shopgate.com>
 * @coversDefaultClass ShopgateCartHelper
 */
class ShopgateCartHelperTest extends PHPUnit_Framework_TestCase
{
    /** @var ShopgateCartHelper */
    protected $class;

    public function setUp()
    {
        $this->class = new ShopgateCartHelper();
    }

    /**
     * @param array  $expected             - tuple of bools
     * @param string $combinationSettingId - combinationId, e.g. 0, 1, 2, 3
     * @param array  $globals              - global key => value settings
     *
     * @runInSeparateProcess
     * @preserveGlobalState disabled
     *
     * @covers ::getStockReductionSettings
     * @dataProvider        stockReductionProvider
     */
    public function testGetStockReductionSettings($expected, $combinationSettingId, $globals)
    {
        //Global setup, this will be normally pulled from the table 'configuration'
        foreach ($globals as $globalKey => $value) {
            define($globalKey, $value);
        }

        $return = $this->class->getStockReductionSettings($combinationSettingId);

        $this->assertEquals($expected, $return);
    }

    /**
     * Expected value is a tuple of whether to update
     * the quantity of ParentStock & PropertyStock
     *
     * @return array
     */
    public function stockReductionProvider()
    {
        return array(
            'id: 0, both globals true' => array(
                'expected'       => array(false, true),
                'combination id' => '0',
                'globals'        => array(
                    'STOCK_CHECK'           => 'true',
                    'ATTRIBUTE_STOCK_CHECK' => 'true'
                )
            ),
            'id: 0, main T, attr F'    => array(
                'expected'       => array(true, false),
                'combination id' => '0',
                'globals'        => array(
                    'STOCK_CHECK'           => 'true',
                    'ATTRIBUTE_STOCK_CHECK' => 'false'
                )
            ),
            'id: 0, main F, attr T'    => array(
                'expected'       => array(false, false),
                'combination id' => '0',
                'globals'        => array(
                    'STOCK_CHECK'           => 'false',
                    'ATTRIBUTE_STOCK_CHECK' => 'true'
                )
            ),
            'id: 0, both false'        => array(
                'expected'       => array(false, false),
                'combination id' => '0',
                'globals'        => array(
                    'STOCK_CHECK'           => 'false',
                    'ATTRIBUTE_STOCK_CHECK' => 'false'
                )
            ),
            'id: 1'                    => array(
                'expected'       => array(true, false),
                'combination id' => '1',
                'globals'        => array(
                    'STOCK_CHECK'           => 'false',
                    'ATTRIBUTE_STOCK_CHECK' => 'false'
                )
            ),
            'id: 1 showing globals do not matter' => array(
                'expected'       => array(true, false),
                'combination id' => '1',
                'globals'        => array(
                    'STOCK_CHECK'           => 'true',
                    'ATTRIBUTE_STOCK_CHECK' => 'true'
                )
            ),
            'id: 2' => array(
                'expected'       => array(false, true),
                'combination id' => '2',
                'globals'        => array(
                    'STOCK_CHECK'           => 'false',
                    'ATTRIBUTE_STOCK_CHECK' => 'false'
                )
            ),
            'id: 3' => array(
                'expected'       => array(false, false),
                'combination id' => '3',
                'globals'        => array(
                    'STOCK_CHECK'           => 'false',
                    'ATTRIBUTE_STOCK_CHECK' => 'false'
                )
            )
        );
    }
}
