<?php

/**
 * Shopgate GmbH
 *
 * URHEBERRECHTSHINWEIS
 *
 * Dieses Plugin ist urheberrechtlich geschützt. Es darf ausschließlich von Kunden der Shopgate GmbH
 * zum Zwecke der eigenen Kommunikation zwischen dem IT-System des Kunden mit dem IT-System der
 * Shopgate GmbH über www.shopgate.com verwendet werden. Eine darüber hinausgehende Vervielfältigung, Verbreitung,
 * öffentliche Zugänglichmachung, Bearbeitung oder Weitergabe an Dritte ist nur mit unserer vorherigen
 * schriftlichen Zustimmung zulässig. Die Regelungen der §§ 69 d Abs. 2, 3 und 69 e UrhG bleiben hiervon unberührt.
 *
 * COPYRIGHT NOTICE
 *
 * This plugin is the subject of copyright protection. It is only for the use of Shopgate GmbH customers,
 * for the purpose of facilitating communication between the IT system of the customer and the IT system
 * of Shopgate GmbH via www.shopgate.com. Any reproduction, dissemination, public propagation, processing or
 * transfer to third parties is only permitted where we previously consented thereto in writing. The provisions
 * of paragraph 69 d, sub-paragraphs 2, 3 and paragraph 69, sub-paragraph e of the German Copyright Act shall remain
 * unaffected.
 *
 * @author             Shopgate GmbH <interfaces@shopgate.com>
 * @coversDefaultClass ShopgateCartHelper
 */
class ShopgateItemCartModelTest extends PHPUnit_Framework_TestCase
{
    /** @var ShopgateItemCartModel */
    protected $class;

    /**
     * Initializing main test class
     */
    public function setUp()
    {
        $this->class = new ShopgateItemCartModel(1);
    }

    /**
     * @param array  $expectedAttributeSelections
     * @param int    $expectedSelectionCount
     * @param array  $orderInfo
     * @param string $delimiter
     *
     * @covers       ShopgateItemCartModel::getCartItemAttributeSelection
     * @dataProvider attributeSelectionProvider
     */
    public function testGetCartItemAttributeSelection(
        $expectedAttributeSelections,
        $expectedSelectionCount,
        $orderInfo,
        $delimiter
    ) {
        $product = new ShopgateOrderItem();
        $product->setInternalOrderInfo(json_encode($orderInfo));

        $attributeSelections = $this->class->getCartItemAttributeSelection($product, $delimiter);

        $this->assertCount($expectedSelectionCount, $attributeSelections);
        $this->assertEquals($expectedAttributeSelections, $attributeSelections);
    }

    /**
     * Set up fake attribute selections
     *
     * @return array
     */
    public function attributeSelectionProvider()
    {
        $delimiter = '-';

        $sampleSelection = array(
            'attribute_1'      => array('59682' => array('options_id' => 1, 'options_values_id' => 1)),
            'attribute_2'      => array('59684' => array('options_id' => 6, 'options_values_id' => 55)),
            'base_item_number' => 1466
        );

        return array(
            'Empty OrderInfo' => array(array(), 0, array(), $delimiter),
            '2 attributes'    => array(
                array('1' . $delimiter . '1', '6' . $delimiter . '55'),
                2,
                $sampleSelection,
                $delimiter
            )
        );
    }
}