<?php

/**
 * Shopgate GmbH
 *
 * URHEBERRECHTSHINWEIS
 *
 * Dieses Plugin ist urheberrechtlich geschützt. Es darf ausschließlich von Kunden der Shopgate GmbH
 * zum Zwecke der eigenen Kommunikation zwischen dem IT-System des Kunden mit dem IT-System der
 * Shopgate GmbH über www.shopgate.com verwendet werden. Eine darüber hinausgehende Vervielfältigung, Verbreitung,
 * öffentliche Zugänglichmachung, Bearbeitung oder Weitergabe an Dritte ist nur mit unserer vorherigen
 * schriftlichen Zustimmung zulässig. Die Regelungen der §§ 69 d Abs. 2, 3 und 69 e UrhG bleiben hiervon unberührt.
 *
 * COPYRIGHT NOTICE
 *
 * This plugin is the subject of copyright protection. It is only for the use of Shopgate GmbH customers,
 * for the purpose of facilitating communication between the IT system of the customer and the IT system
 * of Shopgate GmbH via www.shopgate.com. Any reproduction, dissemination, public propagation, processing or
 * transfer to third parties is only permitted where we previously consented thereto in writing. The provisions
 * of paragraph 69 d, sub-paragraphs 2, 3 and paragraph 69, sub-paragraph e of the German Copyright Act shall remain
 * unaffected.
 *
 * @author             Shopgate GmbH <interfaces@shopgate.com>
 * @coversDefaultClass ShopgateCartHelper
 */
class ShopgateItemModelTest extends PHPUnit_Framework_TestCase
{
    /** @var ShopgateItemModel */
    protected $class;

    /**
     * Initializing main test class including mocked dependencies
     */
    public function setUp()
    {
        $dbHelperMock = $this->getMockBuilder('ShopgateDatabaseHelper')
                             ->disableOriginalConstructor()
                             ->getMock();

        $itemPropertyHelperMock = $this->getMockBuilder('ShopgateItemPropertyHelper')
                                       ->disableOriginalConstructor()
                                       ->setMethods(null)
                                       ->getMock();

        $itemCustomerSetHelperMock = $this->getMockBuilder('ShopgateCustomizerSetHelper')
                                          ->disableOriginalConstructor()
                                          ->setMethods(null)
                                          ->getMock();

        $shopgateConfigMock = $this->getMockBuilder('ShopgateConfigGambioGx')
                                   ->disableOriginalConstructor()
                                   ->getMock();

        $currency = array(
            'decimal_places'  => '',
            'decimal_point'   => '',
            'thousands_point' => '',
            'symbol_left'     => '',
            'symbol_right'    => ''
        );

        $this->class = new ShopgateItemModel(
            $dbHelperMock,
            $itemPropertyHelperMock,
            $itemCustomerSetHelperMock,
            $shopgateConfigMock,
            1,
            $currency,
            1,
            1,
            1
        );
    }

    /**
     * @param array $expectedNames
     * @param array $dataSet
     *
     * @covers       ShopgateItemModel::getInputFieldsFromGxCustomizerSets
     * @dataProvider customizerSetProvider
     */
    public function testGxCustomizerSetInputNames($expectedNames, $dataSet)
    {
        $result = $this->class->getInputFieldsFromGxCustomizerSets($dataSet);
        $result = array_pop($result);

        foreach ($expectedNames as $index => $name) {

            $this->assertEquals($name, $result["input_field_" . ($index + 1) . "_label"]);
        }
    }

    /**
     * Set up fake customer set(s)
     *
     * @return array
     */
    public function customizerSetProvider()
    {
        $multipleCustomizerSet = array(
            '5' => array(
                '5' => array(
                    array(
                        'surfaces_groups_name'      => 'Name & Nummer',
                        'surfaces_groups_id'        => 5,
                        'surfaces_id'               => 5,
                        'surfaces_width'            => 350,
                        'surfaces_height'           => 110,
                        'surfaces_name'             => 'Falls mit Druck: Bitte Name und Nummer eingeben',
                        'elements_id'               => 3,
                        'elements_groups_id'        => 3,
                        'elements_position_x'       => 10,
                        'elements_position_y'       => 75,
                        'elements_position_height'  => 22,
                        'elements_height'           => 22,
                        'elements_position_width'   => 200,
                        'elements_width'            => 200,
                        'elements_position_z_index' => 0,
                        'elements_show_name'        => 1,
                        'elements_group_type'       => 'text_input',
                        'elements_group_name'       => '',
                        'elements_values_id'        => 60,
                        'elements_values_name'      => 'Nummer (max. 2 Ziffern)',
                        'elements_values_value'     => '',
                    ),
                    array(
                        'surfaces_groups_name'      => 'Name & Nummer',
                        'surfaces_groups_id'        => 5,
                        'surfaces_id'               => 5,
                        'surfaces_width'            => 350,
                        'surfaces_height'           => 110,
                        'surfaces_name'             => 'Falls mit Druck: Bitte Name und Nummer eingeben',
                        'elements_id'               => 2,
                        'elements_groups_id'        => 2,
                        'elements_position_x'       => 10,
                        'elements_position_y'       => 25,
                        'elements_position_height'  => 22,
                        'elements_height'           => 22,
                        'elements_position_width'   => 200,
                        'elements_width'            => 200,
                        'elements_position_z_index' => 0,
                        'elements_show_name'        => 1,
                        'elements_group_type'       => 'text_input',
                        'elements_group_name'       => '',
                        'elements_values_id'        => 64,
                        'elements_values_name'      => 'Name (max. 10 Stellen)',
                        'elements_values_value'     => '',
                    )
                )
            )
        );

        $singleCustomerSet = array('10' => array('11' => array($multipleCustomizerSet['5']['5'][0])));

        return array(
            'Multiple Inputs' => array(
                array(' NUMMER (MAX. 2 ZIFFERN)', ' NAME (MAX. 10 STELLEN)'),
                $multipleCustomizerSet
            ),
            'Single Input'    => array(
                array(' FALLS MIT DRUCK: BITTE NAME UND NUMMER EINGEBEN'),
                $singleCustomerSet
            )
        );
    }
}