<?php

/**
 * Shopgate GmbH
 *
 * URHEBERRECHTSHINWEIS
 *
 * Dieses Plugin ist urheberrechtlich geschützt. Es darf ausschließlich von Kunden der Shopgate GmbH
 * zum Zwecke der eigenen Kommunikation zwischen dem IT-System des Kunden mit dem IT-System der
 * Shopgate GmbH über www.shopgate.com verwendet werden. Eine darüber hinausgehende Vervielfältigung, Verbreitung,
 * öffentliche Zugänglichmachung, Bearbeitung oder Weitergabe an Dritte ist nur mit unserer vorherigen
 * schriftlichen Zustimmung zulässig. Die Regelungen der §§ 69 d Abs. 2, 3 und 69 e UrhG bleiben hiervon unberührt.
 *
 * COPYRIGHT NOTICE
 *
 * This plugin is the subject of copyright protection. It is only for the use of Shopgate GmbH customers,
 * for the purpose of facilitating communication between the IT system of the customer and the IT system
 * of Shopgate GmbH via www.shopgate.com. Any reproduction, dissemination, public propagation, processing or
 * transfer to third parties is only permitted where we previously consented thereto in writing. The provisions
 * of paragraph 69 d, sub-paragraphs 2, 3 and paragraph 69, sub-paragraph e of the German Copyright Act shall remain
 * unaffected.
 *
 * @author             Shopgate GmbH <interfaces@shopgate.com>
 * @coversDefaultClass ShopgateCartHelper
 */
class ShopgateItemXmlModelTest extends PHPUnit_Framework_TestCase
{
    /** @var ShopgateItemXmlModel|PHPUnit_Framework_MockObject_MockObject */
    protected $class;

    /**
     * Initializing main test class as mock
     */
    public function setUp()
    {
        $this->class = $this->getMockBuilder('ShopgateItemXmlModel')
                            ->disableOriginalConstructor()
                            ->setMethods(
                                array(
                                    'getInputFieldsToProduct',
                                    'generateOptions',
                                    'calculateOptionPrice',
                                    'calculateTaxRate'
                                )
                            )->getMock();
    }

    /**
     * @param int   $expectedInputCount
     * @param array $inputs
     *
     * @covers       ShopgateItemXmlModel::setInputFields
     * @covers       ShopgateItemXmlModel::generateInputModelForGxInputField
     * @dataProvider inputFieldCountProvider
     */
    public function testSetInputFieldsCount($expectedInputCount, $inputs)
    {
        $this->class->method('getInputFieldsToProduct')
                    ->will($this->returnValue($inputs));

        $reflection = new ReflectionClass(get_class($this->class));
        $method     = $reflection->getMethod('setInputFields');
        $method->setAccessible(true);

        $result = $method->invoke($this->class);
        foreach ($result as $input) {
            $this->assertInstanceOf('Shopgate_Model_Catalog_Input', $input);
        }

        $this->assertCount($expectedInputCount, $result);
    }

    /**
     * @param array $sampleData
     * @param array $inputs
     *
     * @covers       ShopgateItemXmlModel::setInputFields
     * @covers       ShopgateItemXmlModel::generateInputModelForGxInputField
     * @dataProvider inputFieldContentProvider
     */
    public function testSetInputFieldsContent($sampleData, $inputs)
    {
        $this->class->method('getInputFieldsToProduct')
                    ->will($this->returnValue($inputs));

        $reflection = new ReflectionClass(get_class($this->class));
        $method     = $reflection->getMethod('setInputFields');
        $method->setAccessible(true);

        $result = $method->invoke($this->class);
        for ($i = 0; $i < count($result); $i++) {
            $originalInput = $sampleData[$i];
            /** @var Shopgate_Model_Catalog_Input $inputModel */
            $inputModel = $result[$i];
            $this->assertEquals($originalInput['input_field_' . ($i + 1) . '_number'], $inputModel->getUid());
            $this->assertEquals(
                $originalInput['input_field_' . ($i + 1) . '_add_amount'],
                $inputModel->getAdditionalPrice()
            );
            $this->assertEquals($originalInput['input_field_' . ($i + 1) . '_label'], $inputModel->getLabel());
        }
    }

    /**
     * @return array
     */
    public function inputFieldContentProvider()
    {
        $firstInput  = $this->generateInputFieldForNumber();
        $secondInput = $this->generateInputFieldForNumber(2);

        return array(
            '1st level single input'   => array(array($firstInput), $firstInput),
            '1st level multiple input' => array(
                array($firstInput, $secondInput),
                array_merge($firstInput, $secondInput)
            ),
            '2nd level single input'   => array(array($firstInput), array($firstInput)),
            '2nd level multiple input' => array(array($firstInput, $secondInput), array($firstInput, $secondInput))
        );
    }

    /**
     * @return array
     */
    public function inputFieldCountProvider()
    {
        $singleInputs = $this->generateInputFieldForNumber();

        $multipleInputs = array_merge(
            $singleInputs,
            $this->generateInputFieldForNumber(2)
        );

        $secondLevelSingleInputs = array(
            $singleInputs
        );

        $secondLevelMultipleInputs = array(
            $multipleInputs
        );

        return array(
            '1st level single input'   => array(1, $singleInputs),
            '1st level multiple input' => array(2, $multipleInputs),
            '2nd level single input'   => array(1, $secondLevelSingleInputs),
            '2nd level multiple input' => array(2, $secondLevelMultipleInputs),
        );
    }

    /**
     * Generates requested sample input field
     *
     * @param int $number
     *
     * @return array
     */
    private function generateInputFieldForNumber($number = 1)
    {
        return array(
            'has_input_fields'                       => 1,
            'input_field_' . $number . '_type'       => 'text',
            'input_field_' . $number . '_number'     => 'gxcust_el_val_id_#' . $number,
            'input_field_' . $number . '_label'      => 'NAME_' . $number,
            'input_field_' . $number . '_infotext'   => 'INFO_' . $number,
            'input_field_' . $number . '_required'   => rand(0, 1),
            'input_field_' . $number . '_add_amount' => rand(0, 10)
        );
    }
}